Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 79.99, y = 46.06, z = 5, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["campaign"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=-51, x=-40.8, z=4.8, f=1 }, 
	priority = 1, 
	think = "tf_campaign", 
	type = "quest", 
}

Triggers["corp_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_corp_set", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 9, 
	position = { x = 1.0, y = -0.4, z = 11.0, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["rebel_set"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=77.6, x=9.8, z=13.9, f=1 }, 
	priority = 1, 
	think = "tf_rebel_set", 
	type = "quest", 
}

Triggers["relations_vs_rebel"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_rebel", 
	type = "quest", 
}

trigger_functions =
{
tf_campaign = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false		
		if REBELS == Sectors.north_base.owner then
			Triggers["rebel_set"].active = true
		end	
		if CORP == Sectors.north_base.owner then
			Triggers["corp_set"].active = true
		end	
	end
end,
tf_corp_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_on_start = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		if(trigger_utility.isPlayerPresent(trigger_id,PLAYER) ) then			
			Triggers["campaign"].active = true
			trigger.active = false
		end
	end
end,
tf_rebel_set = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
	end
end,
tf_relations_vs_rebel = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, REBELS)
--		changeLocalRelations(ALLY, "rebels")		
		trigger.active = false
	end
end,
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
